/**********************************************************************
*
* lister menu.c -- Version 3.0
*
* Developer Technical Support Apple II Sample Code
*
* Copyright (c)
* Apple Computer, Inc.  1988-1990
* All Rights Reserved.
*
* Written by Eric Soldan.
*
* This file contains the code which implements menus in the
* lister program.
*
**********************************************************************/

#include <types.h>
#include <window.h>
#include <event.h>
#include <menu.h>
#include <desk.h>
#include <intmath.h>
#include <resources.h>

#include "lister.h"

void    appSetMenus();
void    doMenuCommand();

/**********************************************************************/

void    doQuitItem()
{
    quitFlag++;
}

/**********************************************************************/

void            setMItem(id, flag)
unsigned int    id, flag;
{
    if (flag) EnableMItem(id);
    else      DisableMItem(id);
}

/**********************************************************************/

void    doAboutItem()
{
    WindowPtr       wptr, keepPort;
    unsigned long   id;
    unsigned int    item;

    zapLocals();

    keepPort = GetPort();

    wptr = NewWindow2(NULL, NULL, NULL, NULL, 2, AboutWindowID, rWindParam1);
    if (!_toolErr) {
        aboutWindow = wptr;
        for (;;) {
            id = fakeModalDialog(&event, NULL, NULL, NULL,
                fmdMenuSelect+
                fmdMenuKey+
                fmdDeskAcc+
                fmdUpdateAll
            );
            item = id;                              /* Get lo-word. */
            if (id & 0x80000000L) {                 /* If menu command... */
                if (item == 255) {
                    HiliteMenu(0, FileMenuID);      /* Nobody else is going to.       */
                    break;                          /* If close, close the about box. */
                }
                doMenuCommand(id);
                if (quitFlag) break;
            }
            else if (item == 1) break;              /* ...else handle controls. */
        }
    
        SetPort(keepPort);
        CloseWindow(wptr);
        aboutWindow = NULL;
        appSetMenus();
    }
}

/**********************************************************************/

void            doMenuCommand(id)
unsigned long   id;
{
    unsigned int    menuNum, itemNum;

    zapLocals();

    menuNum = HiWord(id) & 0x7FFF;
    itemNum = LoWord(id);

    switch (itemNum) {

        case AboutItem:
            HiliteMenu(0, AppleMenuID);     /* Unhighlight the menu title first. */
            menuNum = 0;                    /* Don't unhilight again. */
            doAboutItem();
            break;

        case QuitItem:
            doQuitItem();
            break;

        case UndoItem:
        case CutItem:
        case CopyItem:
        case PasteItem:
        case ClearItem:
        case CloseItem:
            break;

        case OpenFileItem:
            getFileName(&file, 64, 30, "\pDon't think.  Just pick one.", NULL, NULL);
            break;

        case ChoosePrinterItem:
            PrChooser();
            break;

        case PageSetupItem:
            prRecHandler(0);                    /* PrStlDialog. */
            break;

        case PrintItem:
            doPrint();
            break;
    }

    if (menuNum) HiliteMenu(0, menuNum);        /* Unhighlight the menu title. */
}

/**********************************************************************/

void    setupMenus()
{
    /* Procedure to install our menu titles and their items in the system menu
    ** bar and to redraw it so we can see them.
    */

    SetSysBar(NewMenuBar2(refIsResource, 0x0001L, NULL));
    SetMenuBar(NULL);
    
    FixAppleMenu(AppleMenuID);              /* Add DAs to apple menu     */
    FixMenuBar();                           /* Set sizes of menus        */
    DrawMenuBar();                          /* ...and draw the menu bar! */

    DisableMItem(UndoItem);
    fmdSetMenuProc(appSetMenus);
}

/**********************************************************************/

void    appSetMenus()
{
    unsigned int    about, tabs, frontIsDA, i;

    zapLocals();

    about = tabs = frontIsDA = 0;

    if (aboutWindow) about++;
    if (tabsWindow)  tabs++;
    if (GetWKind(FrontWindow()) & 0x8000) frontIsDA++;

    setMItem(AboutItem, !about);
        /* If about isn't already open, then allow it to be opened. */

    i = about | frontIsDA;
    setMItem(CloseItem, i | tabs);
        /* If we have an about box, tabs window, or DA, then allow close. */

    i = !i;     /* i is true if front window is main or tabs window. */

    setMItem(OpenFileItem, i);
    setMItem(ChoosePrinterItem, i);
    setMItem(PageSetupItem, i);
    setMItem(PrintItem, (i) && (file.pathRef));

    if (!frontIsDA) DisableMItem(UndoItem);
}
